' ------------------------------------------------------------------------------------------------
' Reads the config file
' ------------------------------------------------------------------------------------------------
Function ReadConfigFile:Int()
	
	configfile = OpenStream(title + ".ini")

	If configfile Then
	
		' load configfile
		config.Load(configfile)
		
		' read config settings
		scanflag = Int(config.Get("Scan Notice"))
		scooflag = Int(config.Get("Scoop Notice"))
		warnflag = Int(config.Get("Warnings"))
		starflag = Int(config.Get("Star Details"))
		planflag = Int(config.Get("Planet Details"))
		precflag = Int(config.Get("Precious Details"))
		cashflag = Int(config.Get("Cash Sounds"))
		blipflag = Int(config.Get("Blip Sounds"))
		hornflag = Int(config.Get("Horn Sounds"))
		sampflag = Int(config.Get("Soundset"))
		modeflag = Int(config.Get("Window Mode"))
		tabsflag = Int(config.Get("Tab"))
		saveflag = Int(config.Get("SaveSettings"))
				
		timerange = Int(config.Get("Scan Range"))
		timecorrection = Int(config.Get("TimeCorrection"))
		monitorinterval = Int(config.Get("MonitorInterval"))
		pinginterval = Int(config.Get("PingInterval"))
		channelvolume = Int(config.Get("Volume"))
		ontop = Int(config.Get("Always on Top"))
		Debug = Int(config.Get("Debug Mode"))

		configdate1 = config.Get("CustomStart")
		configdate2 = config.Get("CustomEnd")
		
		voicepath = config.Get("VoiceFolder")

		reward_class_y = Int(config.Get("ClassY"))
		reward_class_t = Int(config.Get("ClassT"))
		reward_class_l = Int(config.Get("ClassL"))
		reward_class_tts = Int(config.Get("ClassTTS"))
		reward_class_m = Int(config.Get("ClassM"))
		reward_class_k = Int(config.Get("ClassK"))
		reward_class_g = Int(config.Get("ClassG"))
		reward_class_f = Int(config.Get("ClassF"))
		reward_class_a = Int(config.Get("ClassA"))
		reward_class_b = Int(config.Get("ClassB"))
		reward_class_o = Int(config.Get("ClassO"))
		reward_class_n = Int(config.Get("ClassN"))
		reward_class_d = Int(config.Get("ClassD"))
		reward_class_h = Int(config.Get("ClassH"))
		reward_class_c = Int(config.Get("ClassC"))
		reward_class_w = Int(config.Get("ClassW"))
		reward_class_x = Int(config.Get("ClassX"))
		
		reward_giant = Int(config.Get("Giant"))
		reward_supergiant = Int(config.Get("Supergiant"))

		reward_earthlike = Int(config.Get("Earthlike"))
		reward_waterworld = Int(config.Get("Waterworld"))
		reward_waterworld_terra = Int(config.Get("WaterworldTerraformable"))
		reward_hmc = Int(config.Get("HighMetalContent"))
		reward_hmc_terra = Int(config.Get("HighMetalContentTerraformable"))
		reward_metalrich = Int(config.Get("MetalRich"))
		reward_ammonia = Int(config.Get("AmmoniaWorld"))
		reward_rocky_terra = Int(config.Get("RockyTerraformable"))
		reward_gas1 = Int(config.Get("GasGiantClass1"))
		reward_gas2 = Int(config.Get("GasGiantClass2"))
		reward_gas3 = Int(config.Get("GasGiantClass3"))
		reward_gas4 = Int(config.Get("GasGiantClass4"))
		reward_gas5 = Int(config.Get("GasGiantClass5"))
		reward_gas_ammonia = Int(config.Get("GasGiantAmmonia"))
		reward_gas_water = Int(config.Get("GasGiantWater"))
		reward_gas_helium = Int(config.Get("GasGiantHelium"))
		reward_gas_watergiant = Int(config.Get("WaterGiant"))
		reward_rocky = Int(config.Get("Rocky"))
		reward_icy = Int(config.Get("Icy"))
		reward_rockyicy = Int(config.Get("RockyIcy"))
		reward_clusterbelt = Int(config.Get("BeltCluster"))
		
	EndIf
	
	Local mx:Int = 10000000
		
	' check values for plausability
	'scanflag = CheckINT(scanflag, 0, 1, 1)
	'scooflag = CheckINT(scooflag, 0, 1, 1)
	'warnflag = CheckINT(warnflag, 0, 1, 1)
	'starflag = CheckINT(starflag, 0, 1, 1)
	'planflag = CheckINT(planflag, 0, 1, 1)
	'precflag = CheckINT(precflag, 0, 1, 1)
	'cashflag = CheckINT(cashflag, 0, 1, 1)
	'blipflag = CheckINT(blipflag, 0, 1, 1)
	'hornflag = CheckINT(hornflag, 0, 1, 1)
	'sampflag = CheckINT(sampflag, 0, 1, 1)
	'modeflag = CheckINT(modeflag, 0, 1, 1)
	'tabsflag = CheckINT(modeflag, 0, 3, 0)
	'saveflag = CheckINT(saveflag, 0, 1, 1)
	
	'reward_class_y = CheckINT(reward_class_y, 1, mx, 2881)
	'reward_class_t = CheckINT(reward_class_t, 1, mx, 2895)
	'reward_class_l = CheckINT(reward_class_l, 1, mx, 2889)
	'reward_class_tts = CheckINT(reward_class_tts, 1, mx, 2895)
	'reward_class_m = CheckINT(reward_class_m, 1, mx, 2903)
	'reward_class_k = CheckINT(reward_class_k, 1, mx, 2916)
	'reward_class_g = CheckINT(reward_class_g, 1, mx, 2919)
	'reward_class_f = CheckINT(reward_class_f, 1, mx, 2932)
	'reward_class_a = CheckINT(reward_class_a, 1, mx, 2949)
	'reward_class_b = CheckINT(reward_class_b, 1, mx, 3012)
	'reward_class_o = CheckINT(reward_class_o, 1, mx, 6135)
	'reward_class_n = CheckINT(reward_class_n, 1, mx, 54782)
	'reward_class_d = CheckINT(reward_class_d, 1, mx, 34294)
	'reward_class_h = CheckINT(reward_class_h, 1, mx, 60589)
	'reward_class_c = CheckINT(reward_class_c, 1, mx, 2930)
	'reward_class_w = CheckINT(reward_class_w, 1, mx, 2931)
	'reward_class_x = CheckINT(reward_class_x, 1, mx, 3077)
	
	'reward_giant = CheckINT(reward_giant, 1, mx, 3122)
	'reward_supergiant = CheckINT(reward_supergiant, 1, mx, 3122)
	
	'reward_earthlike = CheckINT(reward_earthlike, 1, mx, 627885)
	'reward_waterworld = CheckINT(reward_waterworld, 1, mx, 301410)
	'reward_waterworld_terra = CheckINT(reward_waterworld_terra, 1, mx, 694971)
	'reward_hmc = CheckINT(reward_hmc, 1, mx, 34310)
	'reward_hmc_terra = CheckINT(reward_hmc_terra, 1, mx, 412249)
	'reward_metalrich = CheckINT(reward_metalrich, 1, mx, 65045)
	'reward_ammonia = CheckINT(reward_ammonia, 1, mx, 320203)
	'reward_rocky_terra = CheckINT(reward_rocky_terra, 1, mx, 181104)
	'reward_gas1 = CheckINT(reward_gas1, 1, mx, 7013)
	'reward_gas2 = CheckINT(reward_gas2, 1, mx, 53663)
	'reward_gas3 = CheckINT(reward_gas3, 1, mx, 2693)
	'reward_gas4 = CheckINT(reward_gas4, 1, mx, 2799)
	'reward_gas5 = CheckINT(reward_gas5, 1, mx, 2761)
	'reward_gas_ammonia = CheckINT(reward_gas_ammonia, 1, mx, 1721)
	'reward_gas_water = CheckINT(reward_gas_water, 1, mx, 2314)
	'reward_gas_helium = CheckINT(reward_gas_helium, 1, mx, 2095)
	'reward_gas_watergiant = CheckINT(reward_gas_watergiant, 1, mx, 1824)
	'reward_rocky = CheckINT(reward_rocky, 1, mx, 928)
	'reward_icy = CheckINT(reward_icy, 1, mx, 1246)
	'reward_rockyicy = CheckINT(reward_rockyicy, 1, mx, 1246)
	'reward_clusterbelt = CheckINT(reward_clusterbelt, 1, mx, 500)
	
	If timecorrection < - 12 Then timecorrection = -1
	If timecorrection > 12 Then timecorrection = -1
			
	'timerange = CheckINT(timerange, 0, 8, 6)
	'monitorinterval = CheckINT(monitorinterval, 100, 5000, 500)
	'pinginterval = CheckINT(pinginterval, 1000, mx, 8000)
	'channelvolume = CheckINT(channelvolume, 0, 100, 50)
	'ontop = CheckINT(ontop, 0, 1, 0)
	'Debug = CheckINT(Debug, 0, 1, 1)
	
End Function

' ------------------------------------------------------------------------------------------------
' Writes the config file
' ------------------------------------------------------------------------------------------------
Function WriteConfigFile:Int()

	configfile = WriteFile(title + ".ini")
	
	If configfile Then
	
		' create new configfile
		WriteLine(configfile, "[" + title + "]")

		WriteLine(configfile, "Scan Notice=" + scanflag)
		WriteLine(configfile, "Scoop Notice=" + scooflag)
		WriteLine(configfile, "Warnings=" + warnflag)
		WriteLine(configfile, "Star Details=" + starflag)
		WriteLine(configfile, "Planet Details=" + planflag)
		WriteLine(configfile, "Precious Details=" + precflag)
		WriteLine(configfile, "Cash Sounds=" + cashflag)
		WriteLine(configfile, "Blip Sounds=" + blipflag)
		WriteLine(configfile, "Horn Sounds=" + hornflag)
		WriteLine(configfile, "Soundset=" + sampflag)
		WriteLine(configfile, "Window Mode=" + modeflag)
		WriteLine(configfile, "Tab=" + tabsflag)
		WriteLine(configfile, "SaveSettings=" + saveflag)
		
		WriteLine(configfile, "Scan Range=" + timerange)
		WriteLine(configfile, "TimeCorrection=" + timecorrection)
		WriteLine(configfile, "MonitorInterval=" + monitorinterval)
		WriteLine(configfile, "PingInterval=" + pinginterval)
		WriteLine(configfile, "Volume=" + channelvolume)
		WriteLine(configfile, "Always on Top=" + ontop)
		WriteLine(configfile, "Debug Mode=" + Debug)

		WriteLine(configfile, "CustomStart=" + FormatDigit(cal1.dd) + "." + FormatDigit(cal1.mm) + "." + cal1.yy)
		WriteLine(configfile, "CustomEnd=" + FormatDigit(cal2.dd) + "." + FormatDigit(cal2.mm) + "." + cal2.yy)
		
		WriteLine(configfile, "VoiceFolder=" + voicepath)
		
		WriteLine(configfile, "")
		WriteLine(configfile, "[Brown Dwarfs]")
		WriteLine(configfile, "ClassY=" + reward_class_y)
		WriteLine(configfile, "ClassT=" + reward_class_t)
		WriteLine(configfile, "ClassL=" + reward_class_l)
		WriteLine(configfile, "ClassTTS=" + reward_class_tts)
		
		WriteLine(configfile, "")
		WriteLine(configfile, "[Main Sequence Stars]")
		WriteLine(configfile, "ClassM=" + reward_class_m)
		WriteLine(configfile, "ClassK=" + reward_class_k)
		WriteLine(configfile, "ClassG=" + reward_class_g)
		WriteLine(configfile, "ClassF=" + reward_class_f)
		WriteLine(configfile, "ClassA=" + reward_class_a)
		WriteLine(configfile, "ClassB=" + reward_class_b)
		WriteLine(configfile, "ClassO=" + reward_class_o)

		WriteLine(configfile, "")
		WriteLine(configfile, "[Special Stars]")
		WriteLine(configfile, "Giant=" + reward_giant)
		WriteLine(configfile, "Supergiant=" + reward_supergiant)
		WriteLine(configfile, "ClassN=" + reward_class_n)
		WriteLine(configfile, "ClassD=" + reward_class_d)
		WriteLine(configfile, "ClassH=" + reward_class_h)
		WriteLine(configfile, "ClassC=" + reward_class_c)
		WriteLine(configfile, "ClassW=" + reward_class_w)
		WriteLine(configfile, "ClassX=" + reward_class_x)
		
		WriteLine(configfile, "")
		WriteLine(configfile, "[Precious Planets]")
		WriteLine(configfile, "Earthlike=" + reward_earthlike)
		WriteLine(configfile, "Waterworld=" + reward_waterworld)
		WriteLine(configfile, "WaterworldTerraformable=" + reward_waterworld_terra)
		WriteLine(configfile, "HighMetalContent=" + reward_hmc)
		WriteLine(configfile, "HighMetalContentTerraformable=" + reward_hmc_terra)
		WriteLine(configfile, "MetalRich=" + reward_metalrich)
		WriteLine(configfile, "AmmoniaWorld=" + reward_ammonia)
		
		WriteLine(configfile, "")
		WriteLine(configfile, "[Gas Giants]")
		WriteLine(configfile, "GasGiantClass1=" + reward_gas1)
		WriteLine(configfile, "GasGiantClass2=" + reward_gas2)
		WriteLine(configfile, "GasGiantClass3=" + reward_gas3)
		WriteLine(configfile, "GasGiantClass4=" + reward_gas4)
		WriteLine(configfile, "GasGiantClass5=" + reward_gas5)
		WriteLine(configfile, "GasGiantWater=" + reward_gas_water)
		WriteLine(configfile, "GasGiantAmmonia=" + reward_gas_ammonia)
		WriteLine(configfile, "GasGiantHelium=" + reward_gas_helium)
		WriteLine(configfile, "WaterGiant=" + reward_gas_watergiant)
		
		WriteLine(configfile, "")
		WriteLine(configfile, "[Boulders]")
		WriteLine(configfile, "Rocky=" + reward_rocky)
		WriteLine(configfile, "RockyTerraformable=" + reward_rocky_terra)
		WriteLine(configfile, "RockyIcy=" + reward_rockyicy)
		WriteLine(configfile, "Icy=" + reward_icy)
		WriteLine(configfile, "BeltCluster=" + reward_clusterbelt)
				
		CloseStream(configfile)
		
		Return True
		
	Else
	
		Return False
		
	EndIf

End Function